#!/sbin/sh
#
# This leverages the out-of-range utility created by jb881122 which allows us
# to bypass the bootloader checks on jfltevzw and jflteatt
# See here for more information on oor: https://github.com/jb881122/out-of-range
#
#
# Run out-of-range (oor) on boot.img for locked bootloaders
#


if getprop ro.bootloader | grep -E -q -e 'I545VRUAMDK|I545VRUAME7|I545VRUDMI1|I545VRUEMJ7|I545VRUEMK2|I545VRUFNC5|I545VRUFNG6|I545VRUFNK1|FAJP_I545VRUGOC1|I545VRUGOF1|I545VRSGPL1'; then
  echo '[*] Locked bootloader version detected.'
  export C=/tmp/oor_tmpdir
  mkdir -p $C
  dd if=/dev/block/platform/msm_sdcc.1/by-name/aboot of=$C/aboot.img
  if getprop ro.twrp.boot | grep -q 1; then
    toybox mount /dev/block/bootdevice/by-name/system -t ext4 /system
    echo '[*] Patching boot.img with oor and flashing to device.'
    /system/system/vendor/bin/oor -p /dev/block/bootdevice/by-name/aboot /tmp/boot.img /dev/block/bootdevice/by-name/boot || exit 1
    toybox umount /system
  else
    toybox mount /dev/block/bootdevice/by-name/system -t ext4 /mnt/system
    echo '[*] Patching boot.img to with oor and flashing to device.'
    /mnt/system/system/vendor/bin/oor -p /dev/block/bootdevice/by-name/aboot /tmp/boot.img /dev/block/bootdevice/by-name/boot || exit 1
    toybox umount /mnt/system
  fi
  rm -rf $C
else
  echo '[*] Unlocked or unsupported bootloader version detected.'
  echo '[*] Flashing unmodified boot.img to device.'
  echo '[*] UNLESS YOUR DEVICE IS A DEVELOPER EDITION OR OTHERWISE BOOTLOADER UNLOCKED, THIS DEVICE WILL LIKELY NOT BOOT AFTER INSTALLATION.'
  dd if=/tmp/boot.img of=/dev/block/platform/msm_sdcc.1/by-name/boot || exit 1
fi

exit 0
